#include "TableAdapters/MessageTableAdapter.h"

#include <string>
#include <sstream>

namespace DataAccess
{
	MessageTableAdapter::MessageTableAdapter()
	{
	}

	MessageTableAdapter::~MessageTableAdapter()
	{
	}

	//Gets the MessageDataRow from the database by its ID
	MessageDataRow* MessageTableAdapter::FillByID(sqlite3 *dataBase, int id)
	{
		stringstream convert;
		string command = "SELECT * FROM MESSAGE WHERE ID = ";
		convert << id;
		command += convert.str();

		char** result;
		int column, row;

		sqlite3_get_table(dataBase, command.c_str(), &result, &column, &row, NULL);

		MessageDataRow* dataRow = new MessageDataRow(atoi(result[row]), atoi(result[row+1]), result[row+2], result[row+3]);

		return dataRow;
	}

	//Gets the table of MessageDataRows from the database by their GROUPID
	MessageDataTable* MessageTableAdapter::FillByGroupID(sqlite3 *dataBase, int groupID)
	{
		stringstream convert;
		string command = "SELECT * FROM MESSAGE WHERE GROUP_ID = ";
		convert << groupID;
		command += convert.str();

		char** result;
		int column, row;

		sqlite3_get_table(dataBase, command.c_str(), &result, &column, &row, NULL);

		vector<MessageDataRow> tableVector;
		for(int x=0; x<column*row; x+=4)
		{
			tableVector.push_back(MessageDataRow(atoi(result[row+x]), atoi(result[row+x+1]), result[row+x+2], result[row+x+3]));
		}
		MessageDataTable* dataTable = new MessageDataTable(tableVector);

		return dataTable;
	}

	//Inserts the MessageDataRow into the database
	void MessageTableAdapter::InsertMessage(sqlite3* dataBase, int id, int groupID, string text)
	{
		stringstream convert;
		string command = "INSERT INTO MESSAGE (ID, GROUP_ID, TEXT) VALUES(";
		convert << id;
		command += convert.str();
		command += ",";

		convert.str("");
		convert << groupID;
		command += convert.str();
		command += ",'";

		command.append(text);
		command += "')";

		sqlite3_exec(dataBase, command.c_str(), NULL, NULL, NULL);
	}

	//Inserts the MessageDataRow into the database
	void MessageTableAdapter::InsertMessage(sqlite3* dataBase, int id, int groupID, string text, string script)
	{
		stringstream convert;
		string command = "INSERT INTO MESSAGE (ID, GROUP_ID, TEXT, SCRIPT) VALUES(";
		convert << id;
		command += convert.str();
		command += ",";

		convert.str("");
		convert << groupID;
		command += convert.str();
		command += ",'";

		command.append(text);
		command += "','";

		command.append(script);
		command += "')";

		sqlite3_exec(dataBase, command.c_str(), NULL, NULL, NULL);
	}
}